# libraries and data

import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns
from dateutil import parser
import datetime

'''
pat = 'dataset/originalData/inputsA.csv'
inppp=pd.read_csv(pat)
TS=inppp.iloc[1:120,0]
'''
# label=['RF','LGBM','XGB','CBoost','Bagging','ET','XGBRF','AB','GB','DT','K-NN','GP','SVM','Nu-SVM','MLP','BNB','LSVM','LR','PA','SGD','QDA','LDA','Ridge','Perceptron','NC','CNB','MNB', 'GNB']

label=['XGB','CBoost','LGBM','RF','Bagging','XGBRF','AB','ET','MLP','GP','DT', 'SVM','LR','LSVM','SGD','LDA','K-NN','Perceptron','QDA','PA','Ridge', 'GNB','GB','MNB','Nu-SVM','BNB','NC','CNB']

### feature selection and all features
# kappa=[89.9882,88.9850,88.4770,87.3382,82.8392,82.6815,80.7021,78.5255,77.7497,74.5859,75.4415,71.4741,71.5210,70.8249,70.8249,69.7238,66.1049,51.8163,67.9041,46.0293,44.0035,66.6245,0.0000,0.0000,72.9354,7.2329,19.5219,16.1150]
# kappaF=[58.2192,56.8149,56.0142,59.2781,52.6918,56.7157,50.9679,58.7365,50.6641,54.1913,51.6126,42.8301,44.8485,41.0719,43.1358,37.0685,53.1565,46.9595,36.5792,37.8462,25.9893,41.1670,32.6434,25.0920,35.3053,47.3896,51.5503,10.9030]
####### Roc feature and all
kappa=[0.9577,0.9488,0.9443,0.9311	,0.8910	,0.8867	,0.8775,0.8639,0.8720,0.8328,0.8626,0.8190,0.8023,0.7978,0.7978	,0.7932,0.7708,0.6867,0.8673,0.6599	,0.6510,0.9620,0.5000,0.5000,0.9396	,0.5321	,0.8666,0.8366]
kappaF=[ 0.7552 ,0.7449	, 0.7386 ,	 0.7573 ,	 0.7189 ,	 0.7447 ,	 0.7114 ,	 0.7555, 	 0.7156, 	 0.7317,  	 0.7129, 	 0.6327 ,	 0.6757 ,	 0.6557 ,	 0.6665, 	 0.6341 ,	 0.7251 ,	 0.7803 ,	 0.6359, 	 0.6379 ,	 0.5885 ,	 0.6653 ,	 0.6145 ,	 0.4890 ,	 0.6284 ,	 0.7826 ,	 0.7377	, 0.6925]
################ our data with and without balancing
kappa_notbalanced=[89.9882,88.9850,88.4770,87.3382,82.8392,82.6815,80.7021,78.5255,77.7497,74.5859,75.4415,71.4741,71.5210,70.8249,70.8249,69.7238,66.1049,51.8163,67.9041,46.0293,44.0035,66.6245,0.0000,0.0000,72.9354,7.2329,19.5219,16.1150]
kappa_balanced=[88.6833 	, 87.7110 	, 89.0118 	, 87.6294 	, 87.0947 	, 87.7923 	, 85.9880 	, 85.1139 	, 0.0000 	, 74.9258 	, 76.4813 	, 72.4374 	, 71.7235 	, 69.3645 	, 72.3188 	, 77.1834 	, 77.7429 	, 54.5255 	, 63.2158 	, 63.7462 	, 80.0549 	, 62.5109 	, 69.9602 	, 30.6136 	, 76.3945 	, 11.8831 	, 27.1764 	, 30.6136 ]

roc_notbalanced=[0.9577 	, 0.9488 	, 0.9443 	, 0.9311 	, 0.8910 	, 0.8867 	, 0.8775 	, 0.8639 	, 0.8720 	, 0.8328 	, 0.8626 	, 0.8190 	, 0.8023 	, 0.7978 	, 0.7978 	, 0.7932 	, 0.7708 	, 0.6867 	, 0.8673 	, 0.6599 	, 0.6510 	, 0.9620 	, 0.5000 	, 0.5000 	, 0.9396 	, 0.5321 	, 0.8666 	, 0.8366 ]
roc_balanced=[0.9603 	, 0.9598  	, 0.9604   	, 0.9563	, 0.9731 	, 0.9769 	, 0.9418   	, 0.9550     	, 0.5000  	, 0.8850 	, 0.9128   	, 0.8735     	, 0.9566    	, 0.9547   	, 0.9603 	, 0.9166    	, 0.9169          	, 0.9498 	, 0.9428 	, 0.9631        	, 0.9183       	, 0.9455 	, 0.8486   	, 0.8854  	, 0.9599 	, 0.7317	, 0.8769  	, 0.8854 ]


################ Fabiano data with and without balancing
kappa_notbalanced_fabiano=[63.4635, 56.2350, 44.2510 , 43.0349, 26.5137, 37.3369, 21.3116, 38.5653, 37.3369, 42.2603, 35.0954, 28.4650, 0.0000, 21.3116, 22.1322, 45.5579, 51.2691, 0.0000 , 21.3116, 21.3116, 22.1322, 26.6797, 0.0000, 21.3116, 41.3089, 0.0000, 38.6177, 16.0528]
kappa_balanced_fabiano=[62.7213	,66.5425	,56.9861	,52.7725	,54.8217	,52.1874	,58.6759	,56.9861	,0.0000	,52.8803	,39.7806	,33.3901	,23.8974	,24.6038	,19.2587	,21.3709	,52.8567	,27.2838	,16.7599	,1.5209	,21.8146	,15.5811	,28.9843	,16.4454	,31.3699	,0.9392	,32.1601	,10.9658]
roc_notbalanced_fabiano=[0.7910  	, 0.7287  	, 0.6662 	, 0.6661  	, 0.5831  	, 0.6248 	, 0.5624  	, 0.6249  	, 0.6248  	, 0.6456  	, 0.6246  	, 0.5833 	, 0.5000  	, 0.5624  	, 0.5625 	, 0.7892  	, 0.6873  	, 0.5000 	, 0.5624  	, 0.5624  	, 0.5625  	, 0.9458  	, 0.5000  	, 0.5624   	, 0.8016 	, 0.5000  	, 0.8492  	, 0.9545 ]
roc_balanced_fabiano=[0.8918 	, 0.9275 	, 0.8559 	, 0.8202 	, 0.8912 	, 0.8910 	, 0.8561 	, 0.8559 	, 0.5000 	, 0.7329  	, 0.7485 	, 0.7008 	, 0.9556 	, 0.9559 	, 0.9529 	, 0.8846 	, 0.9619 	, 0.9570 	, 0.9508 	, 0.8333   	, 0.8848 	, 0.9496 	, 0.7120 	, 0.9198 	, 0.8619 	, 0.7831 	, 0.9585 	, 0.9765 ]

################ Fontana data with and without balancing
kappa_notbalanced_fontana=[86.5212,86.5212,86.5212,86.5212,88.8606,82.3232,88.6731,91.0141,81.7232,81.4077,86.2924,81.4077,79.2627,81.4077,79.2627,68.9843,84.4048,71.1142,77.5353,81.4077,68.9843,79.9491,79.9491,76.2785,81.4077,74.7292,86.2924,80.2755]
kappa_balanced_fontana=[85.1064,87.1481,84.9045,93.7013,89.3617,85.1064,87.1481,89.3617,0.0000,89.3617,85.1064,89.3617,84.9045,85.1064,17.1505,80.3248,89.5021,70.3583,78.5802,54.7311,80.3248,82.8641,87.3188,76.5957,87.1481,71.5447,84.9045,76.5957]
roc_notbalanced_fontana=[0.9255 	, 0.9255  	, 0.9255 	, 0.9255  	, 0.9407  	, 0.9116  	, 0.9324 	, 0.9476 	, 0.8952 	, 0.8870  	, 0.9173   	, 0.8870  	, 0.8801  	, 0.8870 	, 0.8801 	, 0.8194  	, 0.9186  	, 0.8264  	, 0.8813  	, 0.8870 	, 0.8194  	, 0.8965  	, 0.8965  	, 0.8908  	, 0.8870  	, 0.8920  	, 0.9173  	, 0.9047 ]
roc_balanced_fontana=[0.9227  	, 0.9300  	, 0.9161  	, 0.9716  	, 0.9438   	, 0.9227  	, 0.9300  	, 0.9438  	, 0.5000  	, 0.9438 	, 0.9227  	, 0.9438 	, 0.9161  	, 0.9227  	, 0.6159  	, 0.8883  	, 0.9505  	, 0.8261  	, 0.8877  	, 0.7428  	, 0.8883  	, 0.9088  	, 0.9366 	, 0.8804  	, 0.9300   	, 0.8720  	, 0.9161  	, 0.8804 ]

data=pd.DataFrame([label, roc_notbalanced_fontana,roc_balanced_fontana]).transpose()
data=data.sort_values(by=[2],ascending=False).values
sns.set_context("paper")
# sns.set_style("darkgrid", {"axes.facecolor": ".9"})

# create a color palette
palette = plt.get_cmap('Set1')
width1 = 20
height1 = 16
width_height_1 = (width1, height1)

plt.figure(figsize=width_height_1)

# fig, (ax1, ax2) = plt.subplots(2)
# fig.suptitle('Vertically stacked subplots')
# plt.plot( kappa_notbalanced, color='blue', linestyle='solid', marker='*', markerfacecolor='white', markersize=6, label='Our imbalanced dataset')
# plt.plot( kappa_notbalanced_fontana, color='red', linestyle='solid', marker='+', markerfacecolor='white', markersize=6, label='Fontana imbalanced dataset')
# plt.plot( kappa_notbalanced_fabiano, color='green', linestyle='dashed', marker='^', markerfacecolor='white', markersize=6, label='Fabiano imbalanced dataset')


# plt.plot( data[:,1], color='blue', linestyle='solid', marker='*', markerfacecolor='white', markersize=6, label='Imbalanced data')
# plt.plot( data[:,2], color='red', linestyle='solid', marker='+', markerfacecolor='white', markersize=6, label='Balanced data')

# plt.plot( kappa_balanced_fabiano, color='green', linestyle='dashed', marker='^', markerfacecolor='white', markersize=6, label='Fabiano balanced dataset')

plt.plot( data[:,1], color='blue', linestyle='solid', marker='*', markerfacecolor='white', markersize=6, label='Imbalanced data')
plt.plot( data[:,2], color='red', linestyle='solid', marker='+', markerfacecolor='white', markersize=6, label='Balanced data')

plt.xlabel("Algorithms", fontsize=16)
plt.ylabel("Roc (%)", fontsize=16)


# ax1.set_yticklabels(fontsize=16)
# plt.ylim(0.51, 0.98)
# ax1.set_xticklabels(fontsize=16)
plt.yticks(fontsize=16)
# plt.ylim(0.51, 0.98)
plt.xticks(fontsize=16)
# plt.xticks([0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27], data[:,0], rotation=65)

plt.xticks([0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27], data[:,0], rotation=65)
plt.grid(True)
l = plt.legend(fontsize=16,loc="best")
l.set_zorder(25)
plt.show()

#plt.plot(baselinePrediction, color='green', linestyle='solid',  label='All Features')
#plt.plot(prediction2missing, color='green', linestyle='solid',  label='8 Features')
#plt.plot(prediction4missing, color='green', linestyle='solid',   label='6 Features')

# plt.plot( kappa, color='blue', linestyle='solid', marker='*', markerfacecolor='white', markersize=6, label='Kappa')
# plt.plot( accuracy, color='green', linestyle='dashed', marker='^', markerfacecolor='white', markersize=6, label='Accuracy')
# plt.plot(fmeasure, color='black', linestyle='solid', marker='v', markerfacecolor='white', markersize=6, label='F-Measure')
# plt.plot( precision, color='red', linestyle='solid', marker='+', markerfacecolor='white', markersize=6, label='Precision')
# plt.plot( roc, color='blue', linestyle='dashed', marker='o', markerfacecolor='white', markersize=6, label='Roc Value')


# plt.plot( kappaF, color='blue', linestyle='solid', marker='*', markerfacecolor='white', markersize=6, label='Kappa')
# plt.plot( accuracyF, color='green', linestyle='dashed', marker='^', markerfacecolor='white', markersize=6, label='Accuracy')
# plt.plot(fmeasureF, color='black', linestyle='solid', marker='v', markerfacecolor='white', markersize=6, label='F-Measure')
# plt.plot( precisionF, color='red', linestyle='solid', marker='+', markerfacecolor='white', markersize=6, label='Precision')
# plt.plot( rocF, color='blue', linestyle='dashed', marker='o', markerfacecolor='white', markersize=6, label='Roc Value')

# plt.plot(kappaF, color='green', linestyle='dashed', marker='o', markerfacecolor='yellow', markersize=6, label='Feature Envey')
# plt.plot(accuracyF, color='green', linestyle='dashed', marker='o', markerfacecolor='yellow', markersize=6, label='Feature Envey')
# plt.plot(fmeasureF, color='green', linestyle='dashed', marker='o', markerfacecolor='yellow', markersize=6, label='Feature Envey')
# plt.plot(precisionF, color='green', linestyle='dashed', marker='o', markerfacecolor='yellow', markersize=6, label='Feature Envey')
# plt.plot(rocF, color='green', linestyle='dashed', marker='o', markerfacecolor='yellow', markersize=6, label='Feature Envey')




# plt.plot(fmeasure, color='black', linestyle='solid', marker='v', markerfacecolor='cyan', markersize=6, label='F-measure')
# plt.plot(precision, color='green', linestyle='dashed', marker='o', markerfacecolor='yellow', markersize=6, label='Precision')
# plt.plot(roc,  color='blue', linestyle='solid', marker='*', markerfacecolor='white', markersize=6, label='Roc Value')







"""label=[5,10,50,100,150,200, 400, 600, 800]
i=0
for x,y in zip(df['x2'],df['y2']):
    plt.annotate(label[i], # this is the text
                 (x,y), # this is the point to label
                 textcoords="offset points", # how to position the text
                 xytext=(0,10), # distance from text to points (x,y)
                 ha='left') #
    i += 1

"""






# multiple line plot
"""num = 0
for column in df.drop('x', axis=1):
    num += 1
    plt.plot(df['x'], df[column], marker='', color=palette(num), linewidth=1, alpha=0.9, label=column)
"""
# Add legend


# Add titles
#plt.title("A (bad) Spaghetti plot", loc='left', fontsize=12, fontweight=0, color='orange')


# plt.xlabel("Algorithms", fontsize=16)
# plt.ylabel("Cohen's Kappa (%)", fontsize=16)

# plt.yticks(fontsize=16)
# # plt.ylim(0.51, 0.98)
# plt.xticks(fontsize=16)
# plt.xticks([0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27], label, rotation=65)
# plt.grid(True)
# l = plt.legend(fontsize=16,loc="best")
# l.set_zorder(25)
# plt.show()

# plt.ylabel("Accuracy (%)", fontsize=16) #F-Measure, Precision and Roc values
# plt.ylabel("F-Measure", fontsize=16) #F-Measure, Precision and Roc values
# plt.ylabel("Precision", fontsize=16) #F-Measure, Precision and Roc values
# plt.ylabel("Roc value", fontsize=16) #F-Measure, Precision and Roc values





# plt.yticks(fontsize=16)
# # plt.ylim(0.51, 0.98)
# plt.xticks(fontsize=16)
# plt.xticks([0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27], label, rotation=65)
# plt.grid(True)
# l = plt.legend(fontsize=16,loc="best")
# l.set_zorder(25)
# plt.show()
